%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%    MoM analysis of a parallel-plate capacitor in MATLAB


% k = i) 0.1,(ii) 0.5, (iii) 1, (iv) 2, and (v) 10,


clear all;
close all;
V = 1;
N = 100;
n = sqrt(N);
a = 1;
k = [0.1 0.5 1 2 10]; % given ratio d/a
EPS0 = 8.8542*10^(-12);

[x,y,S] = localCoordinates(n,n,a,a);

C = zeros(1,length(k));
Ca = zeros(1,length(k));

for t = 1:length(k)
d = k(t)*a;
A = matrixACap(EPS0,S,x,y,d);
B = V*ones(N,1);
rhos = inv(A)*B;

for i = 1:n;
    rhos2D(i,:) = rhos((i-1)*n+1:i*n);
end;

X = 0.05:0.1:0.95;
Y = 0.05:0.1:0.95;

figure(1);
surf(X,Y,rhos2D);
title('Surface charge density');
xlabel('x [m]');
ylabel('y [m]');
zlabel('\rho_s [C/m^2]');
colorbar; colormap 'cool'; shading interp; grid off;

Qtot = totalCharge(S,rhos);
C(t) = Qtot/(2*V);

Ca(t) = EPS0*a^2/d;
end;

figure(2);
plot(k , C*10^12 ,'r','linewidth',2);
hold on;
plot(k, Ca*10^12,'b','linewidth',2);
hold off;
xlabel('ratio d/a');
ylabel('C [pF]');
legend('Numerical','Analytical');